/*
 * Decompiled with CFR 0.152.
 */
package org.swampsoft.ffvaapi;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.swampsoft.ffvaapi.FFmpegThread;
import org.swampsoft.ffvaapi.main;

public class MainWindow
extends main {
    boolean isSoftwareInstalled = this.softwareCheck();
    boolean canEncodeH264 = false;
    boolean canEncodeH265 = false;
    boolean canDecodeH264 = false;
    boolean canDecodeH265 = false;
    boolean isMinimized = false;
    String versionNumber = "1.00";
    boolean debug = false;
    Process process;
    BufferedWriter bufferedWriter;
    BufferedReader bufferedReader;
    BufferedReader errorReader;
    FFmpegThread ffmpegThread;
    Preferences preferences = Preferences.userRoot();
    String lastUsedFolder = this.preferences.get("folder", "");
    String progress = "";
    JFrame mainFrame = new JFrame("FFVAAPI H.26X Video Converter for GPUs - Version " + this.versionNumber);
    JButton buttonConvert;
    JButton buttonOpenInputFile;
    JButton buttonOpenOutputFile;
    JTextField fileInputTextField;
    JTextField fileOutputTextField;
    JLabel labelFileInput;
    JLabel labelFileOutput;
    JCheckBox checkboxScale;
    JCheckBox checkboxMuteSound;
    JCheckBox checkboxSetBitRate;
    JTextField textFieldScaleX;
    JTextField textFieldScaleY;
    JLabel labelX;
    JTextField textFieldBitRate;
    ButtonGroup radioButtonGroupH26x;
    JRadioButton radioH264;
    JRadioButton radioH265;
    JLabel labelCodec;
    JLabel labelH26x;
    JLabel labelMegaBit;
    JCheckBox checkboxFrameRate;
    JTextField textFieldFrameRate;

    public MainWindow() {
        this.mainFrame.setDefaultCloseOperation(0);
        this.mainFrame.setSize(600, 350);
        this.mainFrame.setResizable(false);
        this.mainFrame.setLayout(null);
        this.mainFrame.setLocationRelativeTo(null);
        this.mainFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                int result;
                if (MainWindow.this.ffmpegThread != null && MainWindow.this.ffmpegThread.process.isAlive() && (result = JOptionPane.showConfirmDialog(MainWindow.this.mainFrame, "Cancel conversion?", "Cancel?", 0, 3)) == 0) {
                    System.out.println("Destroying ffmpeg process...");
                    MainWindow.this.ffmpegThread.process.destroy();
                    System.out.println("ffmpeg process sent kill signal");
                    MainWindow.this.ffmpegThread.interrupt();
                    MainWindow.this.ffmpegThread = null;
                    MainWindow.this.buttonConvert.setBackground(Color.GREEN);
                    MainWindow.this.buttonConvert.setForeground(Color.WHITE);
                    MainWindow.this.buttonConvert.setText("Convert");
                    MainWindow.this.mainFrame.setTitle("FFVAAPI H.26X Video Converter for GPUs - Version " + MainWindow.this.versionNumber);
                }
                System.exit(0);
            }

            @Override
            public void windowDeiconified(WindowEvent arg0) {
                System.out.println("deiconified");
                MainWindow.this.isMinimized = false;
            }

            @Override
            public void windowIconified(WindowEvent arg0) {
                System.out.println("iconified");
                MainWindow.this.isMinimized = true;
            }
        });
        this.labelFileInput = new JLabel("Enter file to convert:");
        this.labelFileInput.setBounds(20, 10, 200, 30);
        this.mainFrame.add(this.labelFileInput);
        this.labelFileOutput = new JLabel("Enter new file name:");
        this.labelFileOutput.setBounds(20, 80, 200, 30);
        this.mainFrame.add(this.labelFileOutput);
        this.buttonConvert = new JButton("CONVERT");
        this.buttonConvert.setBackground(Color.GREEN);
        this.buttonConvert.setForeground(Color.WHITE);
        Font convertButtonFont = new Font(this.buttonConvert.getFont().getName(), this.buttonConvert.getFont().getStyle(), 20);
        this.buttonConvert.setFont(convertButtonFont);
        this.buttonConvert.setBounds(this.mainFrame.getWidth() - 170, this.mainFrame.getHeight() - 90, 150, 50);
        this.buttonConvert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (MainWindow.this.ffmpegThread != null && MainWindow.this.ffmpegThread.process.isAlive()) {
                    int result = JOptionPane.showConfirmDialog(MainWindow.this.mainFrame, "Cancel conversion?", "Cancel?", 0, 3);
                    if (result == 0) {
                        if (MainWindow.this.ffmpegThread.process.isAlive()) {
                            System.out.println("Destroying ffmpeg process...");
                            MainWindow.this.ffmpegThread.process.destroy();
                            System.out.println("ffmpeg process sent kill signal");
                        }
                        MainWindow.this.ffmpegThread.interrupt();
                        MainWindow.this.ffmpegThread = null;
                        MainWindow.this.buttonConvert.setBackground(Color.GREEN);
                        MainWindow.this.buttonConvert.setForeground(Color.WHITE);
                        MainWindow.this.buttonConvert.setText("Convert");
                        MainWindow.this.mainFrame.setTitle("FFVAAPI H.26X Video Converter for GPUs - Version " + MainWindow.this.versionNumber);
                    }
                } else if (MainWindow.this.checkboxFrameRate.isSelected() && MainWindow.this.textFieldFrameRate.getText().equals("")) {
                    JOptionPane.showMessageDialog(MainWindow.this.mainFrame, "Enter Frame Rate or un-check the box");
                } else {
                    if (MainWindow.this.textFieldBitRate.getText().equals("") && MainWindow.this.checkboxSetBitRate.isSelected()) {
                        JOptionPane.showMessageDialog(MainWindow.this.mainFrame, "Enter BitRate or un-check the box");
                        return;
                    }
                    if (MainWindow.this.checkboxScale.isSelected() && (MainWindow.this.textFieldScaleX.getText().equals("") || MainWindow.this.textFieldScaleY.getText().equals(""))) {
                        JOptionPane.showMessageDialog(MainWindow.this.mainFrame, "Enter X and Y for scale please");
                        return;
                    }
                    if (MainWindow.this.isSoftwareInstalled) {
                        if (MainWindow.this.fileInputTextField.getText().equals("")) {
                            JOptionPane.showMessageDialog(MainWindow.this.mainFrame, "No file is selected. Open a video file first.");
                        } else {
                            if (MainWindow.this.fileOutputTextField.getText().equals("")) {
                                String output = MainWindow.this.fileInputTextField.getText();
                                String[] outputs = output.split(Pattern.quote("."));
                                if (MainWindow.this.radioH264.isSelected()) {
                                    MainWindow.this.fileOutputTextField.setText(output.replace("." + outputs[outputs.length - 1], "-X264.mp4"));
                                } else {
                                    MainWindow.this.fileOutputTextField.setText(output.replace("." + outputs[outputs.length - 1], "-X265.mp4"));
                                }
                                System.out.println(output);
                            }
                            MainWindow.this.convert();
                        }
                    } else {
                        System.out.println("required software is NOT installed");
                        JOptionPane.showMessageDialog(MainWindow.this.mainFrame, "Required software is not installed. Make sure these apps are installed:\n\nffmpeg\nVAAPI drivers for your GPU\nvainfo");
                    }
                }
            }
        });
        this.mainFrame.add(this.buttonConvert);
        this.fileInputTextField = new JTextField("");
        this.fileInputTextField.setBounds(20, 40, 470, 30);
        this.mainFrame.add(this.fileInputTextField);
        this.fileOutputTextField = new JTextField("");
        this.fileOutputTextField.setBounds(20, 110, 470, 30);
        this.mainFrame.add(this.fileOutputTextField);
        this.buttonOpenInputFile = new JButton("Open");
        this.buttonOpenInputFile.setBounds(this.fileInputTextField.getX() + this.fileInputTextField.getWidth() + 10, this.fileInputTextField.getY(), 80, 30);
        this.buttonOpenInputFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fileChooser = new JFileChooser();
                if (MainWindow.this.lastUsedFolder.equals("")) {
                    fileChooser.setCurrentDirectory(new File(System.getProperty("user.home")));
                } else {
                    fileChooser.setCurrentDirectory(new File(MainWindow.this.lastUsedFolder));
                }
                int result = fileChooser.showOpenDialog(MainWindow.this.mainFrame);
                if (result == 0) {
                    File selectedFile = fileChooser.getSelectedFile();
                    MainWindow.this.preferences.put("folder", fileChooser.getCurrentDirectory().getAbsolutePath());
                    MainWindow.this.lastUsedFolder = fileChooser.getCurrentDirectory().getAbsolutePath();
                    if (selectedFile.exists()) {
                        System.out.println("Selected file: " + selectedFile.getAbsolutePath());
                        MainWindow.this.fileInputTextField.setText(selectedFile.getAbsolutePath());
                    } else {
                        JOptionPane.showMessageDialog(MainWindow.this.mainFrame, "File Does not Exist!");
                    }
                }
            }
        });
        this.mainFrame.add(this.buttonOpenInputFile);
        this.buttonOpenOutputFile = new JButton("Open");
        this.buttonOpenOutputFile.setBounds(this.fileOutputTextField.getX() + this.fileOutputTextField.getWidth() + 10, this.fileOutputTextField.getY(), 80, 30);
        this.buttonOpenOutputFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fileChooser = new JFileChooser();
                fileChooser.setCurrentDirectory(new File(System.getProperty("user.home")));
                int result = fileChooser.showOpenDialog(MainWindow.this.mainFrame);
                if (result == 0) {
                    File selectedFile = fileChooser.getSelectedFile();
                    if (selectedFile.exists()) {
                        JOptionPane.showMessageDialog(MainWindow.this.mainFrame, "Warning! File already exists and will be overwritten!");
                    }
                    System.out.println("Selected file: " + selectedFile.getAbsolutePath());
                    MainWindow.this.fileOutputTextField.setText(selectedFile.getAbsolutePath());
                }
            }
        });
        this.mainFrame.add(this.buttonOpenOutputFile);
        this.checkboxScale = new JCheckBox("Set video resolution");
        this.checkboxScale.setBounds(this.fileOutputTextField.getX(), this.fileOutputTextField.getY() + 50, 170, 30);
        this.checkboxScale.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MainWindow.this.checkboxScale.isSelected()) {
                    MainWindow.this.textFieldScaleX.setVisible(true);
                    MainWindow.this.textFieldScaleY.setVisible(true);
                    MainWindow.this.labelX.setVisible(true);
                } else {
                    MainWindow.this.textFieldScaleX.setVisible(false);
                    MainWindow.this.textFieldScaleY.setVisible(false);
                    MainWindow.this.labelX.setVisible(false);
                }
            }
        });
        this.mainFrame.add(this.checkboxScale);
        this.textFieldScaleX = new JTextField();
        this.textFieldScaleX.setBounds(this.checkboxScale.getX() + 170, this.checkboxScale.getY(), 60, 30);
        this.textFieldScaleX.setVisible(false);
        this.mainFrame.add(this.textFieldScaleX);
        this.textFieldScaleY = new JTextField();
        this.textFieldScaleY.setBounds(this.checkboxScale.getX() + 170 + 60 + 20, this.checkboxScale.getY(), 60, 30);
        this.textFieldScaleY.setVisible(false);
        this.mainFrame.add(this.textFieldScaleY);
        this.labelX = new JLabel("X");
        this.labelX.setBounds(this.textFieldScaleX.getX() + 65, this.textFieldScaleX.getY(), 15, 30);
        this.labelX.setVisible(false);
        this.mainFrame.add(this.labelX);
        this.checkboxMuteSound = new JCheckBox("Do not include audio, only video");
        this.checkboxMuteSound.setBounds(this.fileOutputTextField.getX(), this.fileOutputTextField.getY() + 100, 300, 30);
        this.mainFrame.add(this.checkboxMuteSound);
        this.checkboxSetBitRate = new JCheckBox("Set bitrate");
        this.checkboxSetBitRate.setBounds(this.fileOutputTextField.getX(), this.fileOutputTextField.getY() + 150, 110, 30);
        this.checkboxSetBitRate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MainWindow.this.checkboxSetBitRate.isSelected()) {
                    MainWindow.this.textFieldBitRate.setVisible(true);
                    MainWindow.this.labelMegaBit.setVisible(true);
                } else {
                    MainWindow.this.textFieldBitRate.setVisible(false);
                    MainWindow.this.labelMegaBit.setVisible(false);
                }
            }
        });
        this.mainFrame.add(this.checkboxSetBitRate);
        this.textFieldBitRate = new JTextField("");
        this.textFieldBitRate.setBounds(this.checkboxSetBitRate.getX() + 110, this.checkboxSetBitRate.getY(), 60, 30);
        this.textFieldBitRate.setVisible(false);
        this.mainFrame.add(this.textFieldBitRate);
        this.labelMegaBit = new JLabel("Mb");
        this.labelMegaBit.setBounds(this.textFieldBitRate.getX() + 65, this.textFieldBitRate.getY(), 30, 30);
        this.labelMegaBit.setVisible(false);
        this.mainFrame.add(this.labelMegaBit);
        this.radioH264 = new JRadioButton("H.264", false);
        this.radioH264.setBounds(425, 220, 70, 30);
        this.mainFrame.add(this.radioH264);
        this.radioH265 = new JRadioButton("H.265", true);
        this.radioH265.setBounds(500, 220, 70, 30);
        this.mainFrame.add(this.radioH265);
        this.radioButtonGroupH26x = new ButtonGroup();
        this.radioButtonGroupH26x.add(this.radioH264);
        this.radioButtonGroupH26x.add(this.radioH265);
        this.labelH26x = new JLabel("Compression:");
        this.labelH26x.setBounds(this.radioH264.getX(), this.radioH264.getY() - 25, 100, 30);
        this.mainFrame.add(this.labelH26x);
        if (!this.canEncodeH264 && this.canEncodeH265) {
            this.radioH264.setEnabled(false);
            this.radioH264.setSelected(false);
            this.radioH265.setSelected(true);
        } else if (this.canEncodeH264 && !this.canEncodeH265) {
            this.radioH265.setEnabled(false);
            this.radioH264.setSelected(true);
            this.radioH265.setSelected(false);
        } else if (this.canEncodeH264 && this.canEncodeH265) {
            this.radioH264.setSelected(false);
            this.radioH265.setSelected(true);
        }
        this.checkboxFrameRate = new JCheckBox("Set FPS");
        this.checkboxFrameRate.setBounds(425, 155, 80, 30);
        this.checkboxFrameRate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (MainWindow.this.checkboxFrameRate.isSelected()) {
                    MainWindow.this.textFieldFrameRate.setVisible(true);
                } else {
                    MainWindow.this.textFieldFrameRate.setVisible(false);
                }
            }
        });
        this.mainFrame.add(this.checkboxFrameRate);
        this.textFieldFrameRate = new JTextField("");
        this.textFieldFrameRate.setBounds(this.checkboxFrameRate.getX() + 90, this.checkboxFrameRate.getY(), 50, 30);
        this.textFieldFrameRate.setVisible(false);
        this.mainFrame.add(this.textFieldFrameRate);
        this.mainFrame.setVisible(true);
    }

    private boolean softwareCheck() {
        String line;
        Process process;
        ProcessBuilder processBuilder;
        boolean goodToGo;
        block13: {
            goodToGo = false;
            processBuilder = new ProcessBuilder("vainfo");
            try {
                process = processBuilder.start();
                this.bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                System.out.println("Checking for support of FFMPEG, VAAPI, H.264, and H.265...");
                line = "";
                while ((line = this.bufferedReader.readLine()) != null) {
                    if (line.contains("H264") && line.contains("EncSlice")) {
                        System.out.println(String.valueOf(line) + "  - H264 SUPPORTED!");
                        this.canEncodeH264 = true;
                        goodToGo = true;
                        continue;
                    }
                    if (line.contains("HEVC") && line.contains("EncSlice")) {
                        System.out.println(String.valueOf(line) + "  - HEVC SUPPORTED!");
                        this.canEncodeH265 = true;
                        goodToGo = true;
                        continue;
                    }
                    if (line.contains("H264") && line.contains("VLD")) {
                        this.canDecodeH264 = true;
                        continue;
                    }
                    if (!line.contains("HVEC") || !line.contains("VLD")) continue;
                    this.canDecodeH265 = true;
                }
                this.bufferedReader.close();
                if (process.isAlive()) {
                    process.destroy();
                }
            }
            catch (IOException e) {
                if (!e.getMessage().contains("error=2")) break block13;
                System.out.println("vainfo not found!");
                JOptionPane.showMessageDialog(this.mainFrame, "vainfo not found. Install vainfo so I can look at what is supported. Encoding disabled! \n\nInstall with command:\nsudo apt-get install vainfo");
            }
        }
        if (this.canEncodeH264 || this.canEncodeH265) {
            System.out.println("Found Hardware Acceleration Drivers :)");
        }
        processBuilder = new ProcessBuilder("ffmpeg", "-h");
        try {
            process = processBuilder.start();
            this.bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            line = "";
            while ((line = this.bufferedReader.readLine()) != null) {
                if (line.contains("Hyper fast Audio and Video encoder")) {
                    System.out.println("ffmpeg detected  :)");
                    break;
                }
                System.out.println("ffmpeg NOT detected");
                goodToGo = false;
            }
            this.bufferedReader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (goodToGo) {
            System.out.println("Ready to Convert files!");
        }
        return goodToGo;
    }

    private void convert() {
        System.out.println("Converting...");
        this.buttonConvert.setBackground(Color.RED);
        this.buttonConvert.setText("Stop");
        ArrayList<String> fullCmd = new ArrayList<String>();
        fullCmd.add("ffmpeg");
        fullCmd.add("-hwaccel");
        fullCmd.add("vaapi");
        fullCmd.add("-hwaccel_output_format");
        fullCmd.add("vaapi");
        if (this.radioH264.isSelected()) {
            fullCmd.add("-vaapi_device");
        } else {
            fullCmd.add("-hwaccel_device");
        }
        fullCmd.add("/dev/dri/renderD128");
        fullCmd.add("-i");
        String in = this.fileInputTextField.getText();
        fullCmd.add(in);
        if (this.checkboxFrameRate.isSelected()) {
            fullCmd.add("-r");
            fullCmd.add(this.textFieldFrameRate.getText());
        }
        if (this.radioH264.isSelected()) {
            fullCmd.add("-c:v");
            fullCmd.add("h264_vaapi");
            fullCmd.add("-preset");
            fullCmd.add("veryslow");
            fullCmd.add("-crf");
            fullCmd.add("20");
        } else {
            fullCmd.add("-c:v");
            fullCmd.add("hevc_vaapi");
        }
        if (this.checkboxSetBitRate.isSelected()) {
            fullCmd.add("-b:v");
            fullCmd.add(String.valueOf(this.textFieldBitRate.getText()) + "M");
        }
        if (this.radioH264.isSelected() || this.checkboxScale.isSelected()) {
            fullCmd.add("-vf");
            String tempCmd = "";
            if (this.radioH264.isSelected()) {
                tempCmd = String.valueOf(tempCmd) + "hwupload";
            }
            if (this.radioH264.isSelected() && this.checkboxScale.isSelected()) {
                tempCmd = String.valueOf(tempCmd) + ",";
            }
            if (this.checkboxScale.isSelected()) {
                tempCmd = String.valueOf(tempCmd) + "scale_vaapi=";
                tempCmd = String.valueOf(tempCmd) + "w=";
                tempCmd = String.valueOf(tempCmd) + this.textFieldScaleX.getText();
                tempCmd = String.valueOf(tempCmd) + ":h=";
                tempCmd = String.valueOf(tempCmd) + this.textFieldScaleY.getText();
            }
            fullCmd.add(tempCmd);
        }
        if (this.checkboxMuteSound.isSelected()) {
            fullCmd.add("-an");
        }
        fullCmd.add("-y");
        String out = this.fileOutputTextField.getText();
        fullCmd.add(out);
        this.executeFFMPEG(fullCmd);
    }

    private void executeFFMPEG(ArrayList<String> command) {
        String[] fullCmd = new String[command.size()];
        int i = 0;
        while (i < command.size()) {
            fullCmd[i] = command.get(i);
            ++i;
        }
        System.out.println("Using ffmpeg command:");
        i = 0;
        while (i < fullCmd.length) {
            System.out.print(String.valueOf(fullCmd[i]) + " ");
            ++i;
        }
        System.out.println("");
        this.ffmpegThread = new FFmpegThread(this, fullCmd);
        this.ffmpegThread.start();
    }
}

