/*
 * Decompiled with CFR 0.152.
 */
package org.swampsoft.ffvaapi;

import java.awt.Color;
import java.io.IOException;
import java.util.Scanner;
import javax.swing.SwingUtilities;
import org.swampsoft.ffvaapi.MainWindow;

public class FFmpegThread
extends Thread {
    Process process;
    Scanner scanner;
    String[] fullCmd;
    MainWindow mainWindow;

    public FFmpegThread(MainWindow mainWindow, String[] fullCmd) {
        this.mainWindow = mainWindow;
        this.fullCmd = fullCmd;
    }

    @Override
    public void run() {
        System.out.println("Thread running...");
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.command(this.fullCmd);
        try {
            this.process = processBuilder.start();
            this.scanner = new Scanner(this.process.getErrorStream());
            String duration = "";
            String bitrate = "";
            String progress = "";
            String speed = "";
            String title = "";
            long durationMilli = 0L;
            boolean changeTitle = false;
            while (this.scanner.hasNext()) {
                String line = this.scanner.nextLine();
                changeTitle = false;
                if (line.contains("Duration:")) {
                    int durationStart = line.indexOf("Duration:") + 10;
                    duration = line.substring(durationStart, durationStart + 11);
                    System.out.println("Duration: " + duration);
                    int bitrateStart = line.indexOf("bitrate:") + 9;
                    bitrate = line.substring(bitrateStart) + "\n";
                    System.out.println("bitrate: " + bitrate);
                    int hours = Integer.parseInt(duration.substring(0, 2));
                    int minutes = Integer.parseInt(duration.substring(3, 5));
                    int seconds = Integer.parseInt(duration.substring(6, 8));
                    int milli = Integer.parseInt(duration.substring(9));
                    durationMilli = hours * 3600000 + minutes * 60000 + seconds * 1000 + milli * 10;
                } else if (!(line.contains("Stream") && line.contains("Video") || !line.startsWith("frame="))) {
                    int progressStart = line.indexOf("time=") + 5;
                    progress = line.substring(progressStart, progressStart + 11);
                    System.out.print("Progress: " + progress);
                    int speedStart = line.indexOf("speed=") + 6;
                    speed = line.substring(speedStart).trim();
                    System.out.println(" - Speed: " + speed);
                    changeTitle = true;
                    int hours = Integer.parseInt(progress.substring(0, 2));
                    int minutes = Integer.parseInt(progress.substring(3, 5));
                    int seconds = Integer.parseInt(progress.substring(6, 8));
                    int milli = Integer.parseInt(progress.substring(9));
                    long newProgress = hours * 3600000 + minutes * 60000 + seconds * 1000 + milli * 10;
                    double percent = (double)newProgress / (double)durationMilli * 100.0;
                    System.out.println(String.valueOf((int)percent) + "%");
                    title = String.valueOf((int)percent) + "%" + " Speed: " + speed;
                }
                final String finalTitle = title;
                boolean finalChangeTitle = changeTitle;
                if (finalChangeTitle) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            FFmpegThread.this.mainWindow.mainFrame.setTitle(finalTitle);
                        }
                    });
                }
                if (!this.mainWindow.debug) continue;
                System.out.println(line);
            }
            System.out.println("ffmpeg thread closed");
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FFmpegThread.this.mainWindow.buttonConvert.setBackground(Color.GREEN);
                    FFmpegThread.this.mainWindow.buttonConvert.setForeground(Color.WHITE);
                    FFmpegThread.this.mainWindow.buttonConvert.setText("Convert");
                    FFmpegThread.this.mainWindow.mainFrame.setTitle("FFVAAPI H.26X Video Converter for GPUs - Version " + FFmpegThread.this.mainWindow.versionNumber);
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private long convertTime() {
        return 0L;
    }
}

